/*
 * Decompiled with CFR 0.152.
 */
package me.andrew.healthindicators;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Gson GSON = new Gson();
    private static Config INSTANCE = new Config();
    private boolean renderingEnabled = true;
    private boolean heartStackingEnabled = true;
    private int heartOffset = 0;

    public static boolean getRenderingEnabled() {
        return Config.INSTANCE.renderingEnabled;
    }

    public static void setRenderingEnabled(boolean renderingEnabled) {
        Config.INSTANCE.renderingEnabled = renderingEnabled;
        Config.save();
    }

    public static boolean getHeartStackingEnabled() {
        return Config.INSTANCE.heartStackingEnabled;
    }

    public static void setHeartStackingEnabled(boolean heartStackingEnabled) {
        Config.INSTANCE.heartStackingEnabled = heartStackingEnabled;
        Config.save();
    }

    public static int getHeartOffset() {
        return Config.INSTANCE.heartOffset;
    }

    public static void setHeartOffset(int heartOffset) {
        Config.INSTANCE.heartOffset = heartOffset;
        Config.save();
    }

    public static void load() {
        try (BufferedReader reader = new BufferedReader(new FileReader(FabricLoader.getInstance().getConfigDir().resolve("healthindicators.json").toFile()));){
            Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (config != null) {
                INSTANCE = config;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(FabricLoader.getInstance().getConfigDir().resolve("healthindicators.json").toFile()));){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

